/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.validacion;

import ec.gob.sri.dimm.api.modelo.validacion.EstadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.MensajeValidacion;
import java.util.ArrayList;
import java.util.List;

public class ResultadoValidacion {
    private EstadoValidacion estado = EstadoValidacion.EXITOSO;
    private String mensaje;
    private boolean tieneErrores = false;
    private boolean tieneAdvertencias = false;
    private final List<MensajeValidacion> mensajes = new ArrayList<MensajeValidacion>();

    public EstadoValidacion getEstado() {
        return this.estado;
    }

    public void setEstado(EstadoValidacion estado) {
        this.estado = estado;
    }

    public String getMensaje() {
        return this.mensaje;
    }

    public void setMensaje(String mensaje) {
        this.mensaje = mensaje;
    }

    public List<MensajeValidacion> getMensajes() {
        return this.mensajes;
    }

    public boolean esEstadoExitoso() {
        return this.estado == EstadoValidacion.EXITOSO;
    }

    public boolean esEstadoFallido() {
        return this.estado == EstadoValidacion.FALLIDO;
    }

    public boolean tieneVariosErrores() {
        return this.tieneErrores;
    }

    public boolean tieneVariasAdvertencias() {
        return this.tieneAdvertencias;
    }

    public void incluirMensajesValidacion(ResultadoValidacion resultadoValidacion) {
        if (resultadoValidacion.tieneErrores) {
            this.tieneErrores = true;
        }
        if (resultadoValidacion.tieneAdvertencias) {
            this.tieneAdvertencias = true;
        }
        if (!resultadoValidacion.getMensajes().isEmpty()) {
            this.mensajes.addAll(resultadoValidacion.getMensajes());
        }
    }

    public void agregarMensajeValidacion(MensajeValidacion.NivelMensaje nivel, String mensaje) {
        if (!this.tieneErrores && nivel == MensajeValidacion.NivelMensaje.ERROR) {
            this.tieneErrores = true;
        }
        if (!this.tieneAdvertencias && nivel == MensajeValidacion.NivelMensaje.ADVERTENCIA) {
            this.tieneAdvertencias = true;
        }
        this.mensajes.add(new MensajeValidacion(nivel, mensaje));
    }

    public ResultadoValidacion fallarValidacion(String mensaje) {
        this.setMensaje(mensaje);
        this.setEstado(EstadoValidacion.FALLIDO);
        return this;
    }

    public ResultadoValidacion completarValidacionVariosMensajes() {
        this.setEstado(EstadoValidacion.COMPLETO);
        return this;
    }

    public ResultadoValidacion pasarValidacionAdvertencia(String mensaje) {
        this.setMensaje(mensaje);
        this.setEstado(EstadoValidacion.ADVERTENCIA);
        return this;
    }

    public ResultadoValidacion pasarValidacion() {
        this.setMensaje("");
        this.setEstado(EstadoValidacion.EXITOSO);
        return this;
    }
}

